#!/bin/bash
GPUS=$1
SEED=$2
CACHE=$3
ROTAXIS=$4
ROTAXISDIR=$5


RESETTHRES=0.355

array=( $@ )
len=${#array[@]}
EXTRA_ARGS=${array[@]:5:$len}
EXTRA_ARGS_SLUG=${EXTRA_ARGS// /_}

echo extra "${EXTRA_ARGS}"

CUDA_VISIBLE_DEVICES=${GPUS} \
python train.py task=LeapHora train=AllegroHandHora headless=True seed=${SEED} \
task.env.forceScale=2 task.env.randomForceProbScalar=0.25 \
task.env.rotAxis=${ROTAXIS} task.env.rotAxisMult=${ROTAXISDIR} \
train.algo=PPO \
task.env.object.type=cylinder_default \
train.ppo.priv_info=True train.ppo.proprio_adapt=False \
train.ppo.output_name=LeapHora/"${CACHE}" \
task.env.output_name=LeapHora/"${CACHE}" \
task.env.handFacingDir='down' \
task.env.reset_height_threshold=${RESETTHRES} \
task.env.grasp_cache_name='leap_down' \
${EXTRA_ARGS}


